/*
 * Decompiled with CFR 0.152.
 */
package bmv.multicast.client;

import bmv.multicast.conexion.ClienteSocket;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.LinkedBlockingQueue;

public class ClientMulticastSocket {
    public static void main(String[] args) {
        int minimunParameters = 3;
        try {
            if (args.length < 3) {
                System.out.println("Uso:");
                System.out.println("\tjava -jar bmv_ClientMulticastSocket.jar <multicast_group> <port> <interface>");
                System.exit(1);
            }
            ClienteSocket cliente = new ClienteSocket(args[0], Integer.parseInt(args[1]), args[2]);
            LinkedBlockingQueue<byte[]> queue = new LinkedBlockingQueue<byte[]>();
            cliente.setQueue(queue);
            Thread hilo = new Thread(cliente);
            hilo.start();
            int i = 0;
            FileOutputStream fos = new FileOutputStream("real-time.data");
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss:SS", Locale.ENGLISH);
            Date current = null;
            Date reportedDate = null;
            while (true) {
                byte[] paquete = queue.take();
                current = new Date();
                reportedDate = new Date();
                reportedDate.setTime(ClientMulticastSocket.getLong(new byte[]{paquete[9], paquete[10], paquete[11], paquete[12], paquete[13], paquete[14], paquete[15], paquete[16]}));
                System.out.println("FechaHora actual : " + dateFormat.format(current));
                System.out.println("FechaHora paquete: " + dateFormat.format(reportedDate) + ", totalMensajes: " + paquete[2] + ", MarketData: " + paquete[3] + ", secuencia: " + ClientMulticastSocket.getInt(new byte[]{paquete[5], paquete[6], paquete[7], paquete[8]}) + ", msg-bytes: " + Arrays.toString(paquete));
                fos.write(paquete);
                ++i;
                current = null;
                reportedDate = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    private static Long getLong(byte[] arreglo) {
        return ByteBuffer.wrap(arreglo).getLong();
    }

    private static int getInt(byte[] arreglo) {
        return ByteBuffer.wrap(arreglo).getInt();
    }
}

